<?php
/**
 * ZenCode AI Uninstall
 *
 * This file is triggered when the user deletes the plugin from the WordPress admin.
 * It cleans up all custom database tables created by the plugin.
 *
 * @package ZenCodeAI
 */

// If uninstall.php is not called by WordPress, die.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    die;
}

global $wpdb;

// Define all custom table names
$projects_table  = $wpdb->prefix . 'zencode_ai_projects';
$vectors_table   = $wpdb->prefix . 'zencode_ai_kb_vectors';
$versions_table  = $wpdb->prefix . 'zencode_ai_project_versions';
$learnings_table = $wpdb->prefix . 'zencode_ai_learnings';

// Drop all plugin tables
$wpdb->query("DROP TABLE IF EXISTS {$projects_table}");
$wpdb->query("DROP TABLE IF EXISTS {$vectors_table}");
$wpdb->query("DROP TABLE IF EXISTS {$versions_table}");
$wpdb->query("DROP TABLE IF EXISTS {$learnings_table}");

// Delete all plugin options
delete_option('zencode_ai_openai_api_key');
delete_option('zencode_ai_anthropic_api_key');
delete_option('zencode_ai_default_model');
delete_option('zencode_ai_max_tokens');
delete_option('zencode_ai_temperature');

// Clean up any remaining plugin transients
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_zencode_%'");
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_zencode_%'");

// Clean up user meta (optional - remove if you want to preserve user data)
$wpdb->query("DELETE FROM {$wpdb->usermeta} WHERE meta_key LIKE 'zc_%'");
$wpdb->query("DELETE FROM {$wpdb->usermeta} WHERE meta_key LIKE 'zencode_%'");